#import <Foundation/Foundation.h>

@interface PITItem : NSObject <NSCoding>
{
    
}

+ (id) newItem;
- (id) initItem;
+ (id) initWithItemLocation:(NSString *) sLocation itemCity:(NSString *) sCity itemState:(NSString *) sState;

# pragma mark Abstract Objects
@property (nonatomic, strong) PITItem *containedItem;
@property (nonatomic, weak) PITItem *container;

#pragma mark Item Fields (User Controlled)
@property (nonatomic, copy) NSString *itemFirstName;
@property (nonatomic, copy) NSString *itemMiddleName;
@property (nonatomic, copy) NSString *itemLastName;

@property (nonatomic) int itemAge;
@property (nonatomic, copy) NSString *itemGender;
@property (nonatomic) BOOL itemChronic;

@property (nonatomic, copy) NSString *itemFreeLocation;
@property (nonatomic, copy) NSString *itemCity;
@property (nonatomic, copy) NSString *itemState;

#pragma mark Item Fields (App Controlled)
@property (nonatomic) double itemLatitude;
@property (nonatomic) double itemLongitude;
@property (nonatomic) double itemAccuracy;
@property (nonatomic, readonly, strong) NSDate *dateCreated;
//@property (nonatomic, copy) NSString *imageKey;
@property (nonatomic, copy) NSString *itemID;

@end